﻿##################
# Eric Ironside
# Nov 29, 2023
##################

#################
# Before running import the following macro
#
# Macro provided by Pieter v. 
# "How to automate mindmapping? Here is a simple command language and interpreter (macro) to do so!"
# https://community.mindmanager.com/topic/1189-how-to-automate-mindmapping-here-is-a-simple-command-language-and-interpreter-macro-to-do-so
#
# I have another script that automatically dumps my data as an .md file in the right format to be interpreted by Pieter's macro
#################

$file_path = '' # Path to the .md file to process and export as HTML5

# Start a Process
$ps = Start-Process -PassThru -FilePath "C:/Program Files/MindManager 22/MindManager.exe" -WindowStyle "Maximized"

# Creating WScript.Shell instance
$wshell = New-Object -ComObject wscript.shell

# Wait until activating the target process succeeds.
# Note: You may want to implement a timeout here.
while (-not $wshell.AppActivate($ps.Id)) {
  
  # Waiting for app to start....
  Start-Sleep -MilliSeconds 200
}

Sleep 5
# Advanced + Visual Basic (macro)
$wshell.SendKeys("%AVB")
Sleep 2

# Scroll down to our macro (third in the list, yours may be different) and run it
$wshell.SendKeys("{Down}")
$wshell.SendKeys("{Down}")
$wshell.SendKeys("{Enter}")
# Provide a path to the MD file
sleep 2
$wshell.SendKeys($file_path)
$wshell.SendKeys("{Enter}")

# Sleep long enough to create the map
Sleep 20

# Dismiss the macro dialog
$wshell.SendKeys("{Enter}")
sleep 1
$wshell.SendKeys("%WC")
sleep 1
# File > Export > HTML
$wshell.SendKeys("%FEH")
Sleep 1
# File path\name to export the HTML
$wshell.SendKeys("C:\inetpub\wwwroot\Status.html")
# Save the file
$wshell.SendKeys("{enter}")
Sleep 1
# Overwrite the file if it exists
$wshell.SendKeys("{left}")
Sleep 1
$wshell.SendKeys("{enter}")
Sleep 10
# Wait for the file to be exported, exit the Open/Close dialog
$wshell.SendKeys("{enter}")
Sleep 1
# File > Exit
$wshell.SendKeys("%Fx")
Sleep 1
# Dont save Map 1 (Default map on open)
$wshell.SendKeys("{right}")
$wshell.SendKeys("{enter}")
Sleep 1
# Save Map 2 (map imported from .md file)
$wshell.SendKeys("Status.mmap")
$wshell.SendKeys("{enter}")
Sleep 1
# Overwrite the file if it exists
$wshell.SendKeys("{left}")
Sleep 1
$wshell.SendKeys("{enter}")